<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van QUMT_IN900009NL - Signal Subscription Query, Response</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <include href="coreschematron/xml.sch"/>
    <include href="coreschematron/attentionLine.sch"/>

    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>
    
    <!--pattern is-a="attentionLine" id="QUMT_IN900009NL-attentionLine">
        <param name="messagePatientId" value="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:subject2/hl7:ActReference/hl7:recordTarget/hl7:patient/hl7:id"/>
    </pattern-->
    
    <pattern is-a="transmission-wrapper" id="QUMT_IN900009NL-wrapper">
        <param name="element" value="hl7:QUMT_IN900009NL"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="QUMT_IN900009NL-controlAct">
        <param name="element" value="hl7:QUMT_IN900009NL/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:QUMT_IN900009NL/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:QUMT_IN900009NL/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
        <rule context="hl7:QUMT_IN900009NL/hl7:attentionLine">
            <assert role="warning" test="not(.)">Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>Zender en ontvanger</title>
        <rule context="hl7:QUMT_IN900009NL/hl7:sender/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"
                >De zender van deze interactie moet de ZIM zijn</assert>
        </rule>
        <rule context="hl7:QUMT_IN900009NL/hl7:receiver/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1')"
                >De ontvanger van deze interactie moet een AORTA applicatie zijn, en kan niet de ZIM zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>ControlActProcess/subject</title>
        <rule context="hl7:ControlActProcess">
            <assert role="error" test="not(hl7:subject)"
                >In het initiële antwoord op het abonnementverzoek kan geen payload/inhoud zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>ControlActProcess/queryAck</title>
        <rule context="hl7:ControlActProcess/hl7:queryAck/hl7:resultTotalQuantity">
            <assert role="error" test="@value='0'"
                ><value-of select="local-name()"/>/@value moet '0' zijn</assert>
        </rule>
        <rule context="hl7:ControlActProcess/hl7:queryAck/hl7:resultCurrentQuantity">
            <assert role="error" test="@value='0'"
                ><value-of select="local-name()"/>/@value moet '0' zijn</assert>
        </rule>
        <rule context="hl7:ControlActProcess/hl7:queryAck/hl7:resultRemainingQuantity">
            <assert role="error" test="@value='0'"
                ><value-of select="local-name()"/>/@value moet '0' zijn</assert>
        </rule>
    </pattern>
</schema>
